* binom_plot.sas;
title "Plot probabilities for the binomial distribution";
title2 "l = 10, p = 0.5";
data binom_plot;
	* Binomial parameters here;
	l = 10;
	p = 0.5;
	do y=0 to l;
		* Binomial distribution function;
		proby = pdf('binomial',y,p,l); 
		* Output y and proby to SAS data file;
		output;
	end;
run;
* Print data;
proc print data=binom_plot;
run;
* Plot probabilities;
proc gplot data=binom_plot;
	plot proby*y=1 / vref=0 wvref=3 vaxis=axis1 haxis=axis1;
	symbol1 i=needle v=dot c=red width=3 height=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
